/*----------------------------------------------------------------------
 | VAR.C							940420
 |
 | Contains all global variables.
 +----------------------------------------------------------------------*/


#include "var.h"


BoardIndexType  lastMovedPieceSquare;   /* Square last played piece moved to */
Unsigned1       nrCheck;
CheckPieceType  checkingPiece[2];
DirectionType   pinned[H8 + 1];
SquareType      board[NrSquares];
BoardIndexType  epSquare[MaxGamePlies]; /* EP status during game */
Unsigned1       castling[MaxGamePlies]; /* castling status during game */
HashType        hashValue[MaxGamePlies];        /* hash values of game
                                                 * positions */
Unsigned2       startHashIndex[MaxGamePlies];   /* 50 move rule indices */
SquareType      toMove;
Unsigned4       material[2];
ValueType       positionalValue[2];
Unsigned2       pieceValue[128];
char            pieceSymbol[256];
PieceType       pieces[2][16];
Unsigned1       nrPieces[2];
Unsigned1       pieceIndex[H8 + 1];
BoardIndexType  kingSquare[2];
char            gameString[MaxGamePlies][MaxMoveLength];        /* moveStrings */
MoveType        game[MaxGamePlies];     /* Real moves in the game */
Unsigned2       nrGamePlies,
                maxGamePlies;
Unsigned2       startPly;       /* Ply number of game when the search starts */
SquareType      computer;
Unsigned4       nrInternalNodes,
                nrLeafNodes,
                nrQuiesNodes;
Unsigned4       nrIllegalMoves;
double          startingTime;
Unsigned4       nrTotalNodes,
                nrExtraNodes;
Unsigned2       nrAllocMoveLists,
                nrAllocPathMoves;
Boolean         stopSearching;
char           *moveColorString[2] =
{"BTM", "WTM"};
#ifdef Bcc
Unsigned2 huge  historyTable[2][H8 + 1][H8 + 1];
#else
Unsigned2       historyTable[2][H8 + 1][H8 + 1];
#endif
Signed2         pawnEvalTable[2][H8 + 1];
Signed2         knightEvalTable[2][H8 + 1];
Signed2         bishopEvalTable[2][H8 + 1];
Signed2         rookEvalTable[2][H8 + 1];
Signed2         queenEvalTable[2][H8 + 1];
Signed2         kingEvalTable[2][H8 + 1];
Boolean         interActive,
                doTest,
                useTransTable,
                useRefTable;
Boolean         useTwoLevelTable,
                useTtValue,
                useTtMove,
                timeStamp,
                useFlag;
TtEntry        *transTable;
Unsigned4       nrCollisions,
                nrHits,
                nrReads,
                nrWrites;
Signed4         testNrNodes;
Unsigned1       nrTtBits;
Unsigned2       keepPly;
Unsigned1       keepMethod;
char           *methodString[5] =
{"New", "Old", "Deep", "Big1", "BigAll"};
Unsigned2       debugDepth;

char           *logicString[2] =
{"False", "True"};

/* pack arrays because of transposition table entries */
Unsigned1       packPiece[Edge];
SquareType      unpackPiece[4]; /* 2 bits */
Unsigned1       packSquare[H8 + 1];
BoardIndexType  unpackSquare[64];       /* 6 bits */
Unsigned1       packType[64];
Unsigned1       unpackType[8];  /* 3 bits */

/* move tables */
#ifdef Bcc
BoardIndexType huge knightTable[H8 + 1][MaxKnightMoves];
BoardIndexType huge bishopTable[H8 + 1][4][MaxBishopMoves];
BoardIndexType huge rookTable[H8 + 1][4][MaxRookMoves];
BoardIndexType huge pawnMoveTable[2][H8 + 1][2];
BoardIndexType huge pawnCaptureTable[2][H8 + 1][2];
#else
BoardIndexType  knightTable[H8 + 1][MaxKnightMoves];
BoardIndexType  bishopTable[H8 + 1][4][MaxBishopMoves];
BoardIndexType  rookTable[H8 + 1][4][MaxRookMoves];
BoardIndexType  pawnMoveTable[2][H8 + 1][2];
BoardIndexType  pawnCaptureTable[2][H8 + 1][2];
#endif

/* move directions */
DirectionType   knightDir[8] =
{Up + Up + Right, Up + Up + Left, Down + Down + Right,
    Down + Down + Left, Right + Right + Up, Right + Right + Down,
Left + Left + Up, Left + Left + Down};
DirectionType   bishopDir[4] =
{Up + Right, Up + Left, Down + Right, Down + Left};
DirectionType   rookDir[4] =
{Up, Down, Right, Left};
DirectionType   pawnCaptureDir[2][2] =
{
    {Down + Right, Down + Left},
{Up + Right, Up + Left}};

/* commands */
char           *commandString[MaxCommands][2] =
{
    {"q", "quit"},
    {"h", "help"},
    {"m", "move"},
    {"pb", "printboard"},
    {"lm", "list"},
    {"f", "forward"},
    {"b", "back"},
    {"n", "new"},
    {"pg", "printgame"},
    {"c", "compute"},
    {"s", "save"},
    {"l", "load"},
    {"cb", "clear"},
    {"pp", "place"},
    {"rp", "remove"},
    {"sp", "savepos"},
{"t", "test"}};

Signed2         centreTable[H8 + 1] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 20, 40, 40, 20, 10, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 30, 50, 70, 70, 50, 30, 10, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 50, 80, 110, 110, 80, 50, 20, 0, 0, 0, 0, 0, 0, 0,
    0, 40, 70, 110, 160, 160, 110, 70, 40, 0, 0, 0, 0, 0, 0, 0,
    0, 40, 70, 110, 160, 160, 110, 70, 40, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 50, 80, 110, 110, 80, 50, 20, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 30, 50, 70, 70, 50, 30, 10, 0, 0, 0, 0, 0, 0, 0,
0, 0, 10, 20, 40, 40, 20, 10, 0};

HashType        pawnHashTable[2][H8 + 1];
HashType        knightHashTable[2][H8 + 1];
HashType        bishopHashTable[2][H8 + 1];
HashType        rookHashTable[2][H8 + 1];
HashType        queenHashTable[2][H8 + 1];
HashType        kingHashTable[2][H8 + 1];
HashType        movedHash;
HashType        enPassantHashTable[H + 1];
HashType        castlingHashTable[2][2];

Boolean         printDebug;

char           *version = "24 january 1995";

Unsigned4       nrMovesGenerated,
                nrGenerates;
